' ------------------------------------------------------------------------------------------------
' Usage: Global MainBeat:TBeat = New TBeat.Create (Rand(10,200) , FunctionToExecute)
' ------------------------------------------------------------------------------------------------
Type TBeat

	Field Length:Int								' Length of Beat in Milli seconds
	Field Ticker:TTimer								' The actual Timer
	Field MyEvent:TEvent = New TEvent				' The Event the Timer is tied to
	Field BeatFunction(Caller:TBeat, event:TEvent)	' The Function to be called on Beat

	Method Create:TBeat (Length:Int = 1000, BeatFunction(Caller:TBeat, event:TEvent) = Null)

		Self.Length = Length						' Let the New Beat length = length
		Local hertz:Float = 1000.0 / Length			' Stupid Bmx Hertz 
		AddHook EmitEventHook, EventHook, Self		' Start the Hook
		Self.Ticker = CreateTimer (hertz)			' Create the timer
		Self.BeatFunction = BeatFunction			' Set the Function to call
		Return Self									' Return the New TBeat

	End Method

	Method CreateHertz:TBeat (hertz:Float=60.0, BeatFunction(Caller:TBeat, event:TEvent) = Null)

		Self.Length = 1								' Let the New Beat length = length
		AddHook EmitEventHook, EventHook, Self		' Start the Hook
		Self.Ticker = CreateTimer (hertz)			' Create the timer
		Self.BeatFunction = BeatFunction			' Set the Function to call
		Return Self									' Return the New TBeat

	End Method
	
	Function EventHook:Object(id:Int, data:Object, context:Object)

		If TBeat(context) TBeat(context).Ev TEvent(data) ;Return data

	EndFunction

	Method free()

		' Release the Hook
		RemoveHook EmitEventHook, EventHook
		
		' Do Garbage Collection
		GCCollect()

	End Method

	Method Ev(event:TEvent)

		' See if the Event was A Beat
		If event.id = EVENT_TIMERTICK And event.source = Ticker

			' Pass control tothe right Function
			BeatFunction(Self, event)

		EndIf

	End Method

	Method HowManyTicks:Int ()

		' Return the number of Ticks
		Return TimerTicks(Ticker)

	EndMethod

	Method GetFrequancy:Float ()

		' Return the Hertz
		Return (1000.0 / Length)

	End Method

End Type